<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Email Campaign Manager</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: auto;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
        }

        label {
            font-weight: bold;
        }

        input,
        select,
        button {
            width: 100%;
            margin: 10px 0;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        #editor {
            height: 200px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        button {
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Compose Email</h1>
        <form action="send_email.php" method="post">
            <label for="to">To:</label>
            <input type="email" name="to" id="to" required>

            <label for="cc">Cc:</label>
            <input type="email" name="cc" id="cc">

            <label for="subject">Subject:</label>
            <input type="text" name="subject" id="subject" required>

            <label for="editor">Message:</label>
            <div id="editor"></div>
            <input type="hidden" name="message" id="message">

            <button type="submit">Send Email</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.min.js"></script>
    <script>
        const quill = new Quill('#editor', {
            theme: 'snow'
        });
        const form = document.querySelector('form');
        form.onsubmit = () => {
            document.querySelector('#message').value = quill.root.innerHTML;
        };
    </script>
</body>

</html>